<?php
use PHPUnit\Framework\TestCase;

include 'Prepare_DB.php';

class UserFactory
{
    public $prepare_DB;
    public $start_connection;
    public $mysql_query;
    public $response = array();
    public $login_state;
    public $signup_state;

    public function __construct()
    {
        $this->prepare_DB = new Prepare_DB();
        $this->mysql_query = null;
        $this->login_state = null;
        $this->signup_state = null;

    }


    function login($table, $phone, $password)
    {

        $input_phone = ($this->MakeItSafe($phone));
        $input_password = ($this->MakeItSafe($password));
        
        $this->mysql_query = "select * from " . $table . " where user_phone = '" . $input_phone . "'";
        $result = mysqli_query($this->start_connection, $this->mysql_query);
        $row = $result->fetch_assoc();

        if (mysqli_num_rows($result) != 0) {

            $db_password = $row['password'];
          //  $db_email = $row['user_email'];
            $db_phone = $row['user_phone'];

            if ($db_phone == $input_phone && password_verify($input_password , $db_password)) {

                $this->response['status'] = true;
                $this->response['message'] = "Login Ok";
                $this->response['data'] = [

'id'=>$row['id'],
                    'phone' =>$db_phone,
                    'first_name' => $row['first_name'],
                    'last_name' => $row['last_name']
                ];
                $this->login_state = true;

                echo json_encode($this->response,JSON_PRETTY_PRINT);
            } else {
                $this->response['status'] = false;
                $this->response['message'] = "Password Wrong";
                echo json_encode($this->response,JSON_PRETTY_PRINT);

                $this->login_state = false;
            }


        } else {
            $this->response['status'] = false;
            $this->response['message'] = "YOU HAVE NOT AN ACCOUNT !";
            echo json_encode($this->response, JSON_PRETTY_PRINT);
            $this->login_state = false;
        }

        return $this->login_state;


    }


    function signup($table, $password,$firstname, $lastname, $phone)
    {
        $input_password = ($this->MakeItSafe($password));
        $input_firstname = ($this->MakeItSafe($firstname));
        $input_lastname = ($this->MakeItSafe($lastname));
        $input_phone = ($this->MakeItSafe($phone));

        $checkquery3 = "select * from " . $table . " where user_phone = '" . $input_phone . "'";
        $checkresult3 = mysqli_query($this->start_connection, $checkquery3);

         if(mysqli_num_rows($checkresult3)!=0){

            $response['status'] = false;
               $response['message'] = "شما یک حساب با این شماره تلفن دارید !";
                  $response['data'] = [
                     'id'=>'111',
                    'phone'=>$input_phone,
                    'first_name' => $input_firstname,
                    'last_name' => $input_lastname
             ];
            echo  json_encode($response,JSON_PRETTY_PRINT);
                $this->signup_state=false;

        }
        else{


            $input_password_hashed=password_hash($input_password,PASSWORD_DEFAULT);
            $this->mysql_query = "INSERT INTO " . $table
                . "(password,first_name,last_name,user_phone) VALUES ('"
                .  $input_password_hashed . "','" . $input_firstname
                . "','" . $input_lastname ."','".$input_phone. "')";
            $result = mysqli_query($this->start_connection, $this->mysql_query);
            $row=mysqli_fetch_assoc($checkresult3);

            if ($result) {

            $this->response['status'] = true;
            $this->response['message'] = "you have registered !";
                $response['data'] = [
                    'id'=>$row['id'],
                    'phone' => $input_phone,
                    'first_name' => $input_firstname,
                    'last_name' => $input_lastname
                ];
                echo json_encode($response);
                $this->signup_state=true;
            }



        }
        return $this->signup_state;



    }


// This function should be used in the input / registration file

    function StartConnection()
    {

        $this->start_connection = new mysqli($this->prepare_DB->getHost(), $this->prepare_DB->getUser(), $this->prepare_DB->getPass(), $this->prepare_DB->getDb());
        return $this->start_connection;


    }


    function MakeItSafe($data)
    {


        return mysqli_real_escape_string($this->start_connection, stripslashes(htmlspecialchars($data)));

    }


}
